<!doctype html>

<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 8]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->

	<head>
		<meta charset="utf-8">

		<title><?php wp_title(''); ?></title>

		<!-- Google Chrome Frame for IE -->
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

		<!-- mobile meta -->
		<meta name="HandheldFriendly" content="True">
		<meta name="MobileOptimized" content="320">
		<meta name="viewport" content="width=device-width, initial-scale=1.0"/>

		<!-- icons & favicons -->
		<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri(); ?>/library/images/apple-icon-touch.png">
		<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/favicon.png">
		<!--[if IE]>
			<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/favicon.ico">
		<![endif]-->
		<meta name="msapplication-TileColor" content="#f01d4f">
		<meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/library/images/win8-tile-icon.png">

  	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

		<?php wp_head(); ?>
        
        <!-- TypeKit code starts here -->
        <script type="text/javascript" src="//use.typekit.net/udo1ysl.js"></script>
        <script type="text/javascript">try{Typekit.load();}catch(e){}</script>
        <!-- TypeKit code ends here -->

		<!-- Drop Google Analytics here -->
        
        <script>
            (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
            (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
            m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
            })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

            ga('create', 'UA-50617511-1', 'kantilenamalta.com');
            ga('send', 'pageview');

        </script>
        
		<!-- end analytics -->

	</head>

	<body <?php body_class(); ?>>

	<div class="off-canvas-wrap">
		<div class="inner-wrap">
			<div id="container">
                    
            <section id="abovefold" class="show-for-large-up">
                
                <div class="abovefold-overlay">
                    <div class="row-1"></div>
                    <div id="intro-text" class="row-2">
                        <div class="large-4 large-centered columns">
                            <img src="<?php echo get_template_directory_uri(); ?>/library/images/kantilena-logo-centered.png" alt="Kantilena Logo"/>
                        </div>
                        <div class="large-12 medium-12 end columns">
                            <h1 class="text-center">
                                <em><?php echo types_render_field("intro-text", array("output"=>"raw","argument2"=>"value2")); ?></em>
                            </h1>
                        <div id="scrolldown" class="text-center"><i class="fi-arrow-down"></i></div>
                        </div>
                    </div>
                    <div class="row-3"></div>
                </div>

            </section> <!-- end #above-fold -->
                
            <section id="belowfold">
                
                    <header class="header" role="banner">

                        <div id="inner-header" class="row">
                                                    
                            <div class="large-12 columns">
                                
                                <div class="large-4 medium-4 columns show-for-medium-up logo-area">
                                    <img src="<?php echo get_template_directory_uri(); ?>/library/images/kantilena-logo.png" alt="Kantilena Logo"/>
                                </div>
                                
                                <div class="large-8 medium-8 columns show-for-medium-up text-right description-area">
                                    <h3><em><?php bloginfo('description'); ?></em></h3>
                                </div>
                                
                                <div class="small-10 small-centered columns show-for-small-only logo-area">
                                    <img src="<?php echo get_template_directory_uri(); ?>/library/images/kantilena-logo-centered.png" alt="Kantilena Logo"/>
                                </div>
                                
                                <!-- h1><a href="<?php // echo home_url(); ?>" rel="nofollow"><?php // bloginfo('name'); ?></a></h1 -->
                                
                                
                                
                                <!-- nav>
                                    <div data-magellan-expedition="fixed">
                                        <dl class="sub-nav">
                                            <dd data-magellan-arrival="bijografija"><a href="#bijografija">Dwar Kantilena</a></dd>
                                            <dd data-magellan-arrival="filmati"><a href="#filmati">Filmati</a></dd>
                                            <dd data-magellan-arrival="ritratti"><a href="#ritratti">Ritratti</a></dd>
                                            <dd data-magellan-arrival="kuncerti-passati"><a href="#kuncerti-passati">Kunċerti</a></dd>
                                            <dd data-magellan-arrival="hajr"><a href="#hajr">Ħajr</a></dd>
                                        </dl>
                                    </div>
                                </nav -->
                                
                            </div>
                            
                            <?php // get_template_part( 'partials/nav', 'offcanvas' ); ?>

                            <?php // get_template_part( 'partials/nav', 'topbar' ); ?>

                            <?php // get_template_part( 'partials/nav', 'offcanvas-sidebar' ); ?>

                            <!-- You only need to use one of the above navigations.
                             Offcanvas-sidebar adds a sidebar to a "right" offcanavas menus. -->

                        </div> <!-- end #inner-header -->

                    </header> <!-- end header -->