<?php
require_once 'abstract.form.php';
require_once 'class.eforms.php';
require_once 'class.field_factory.php';

define( "CLASS_NAME_PREFIX", "WPToolset_Field_" );

/**
 * FormFactory
 * Creation Form Class 
 * @author onTheGo System
 *
 * $HeadURL: https://www.onthegosystems.com/misc_svn/common/tags/Views-1.6-Types-1.5.6/toolset-forms/classes/class.form_factory.php $
 * $LastChangedDate: 2014-04-15 16:12:53 +0000 (Tue, 15 Apr 2014) $
 * $LastChangedRevision: 21541 $
 * $LastChangedBy: francesco $
 *
 *
 */
class FormFactory extends FormAbstract
{

    private $field_count = 0;
    private $form = array();
    private $nameForm;
    private $theForm;
    protected $_validation, $_conditional, $_repetitive, $_use_bootstrap;

    public function __construct( $nameForm = 'default' )
    {
        if ( !isset( $GLOBALS['formFactories'] ) )
            $GLOBALS['formFactories'] = array();
        $this->nameForm = $nameForm;
        $this->field_count = 0;
        $this->theForm = new Enlimbo_Forms( $nameForm );
        $this->_use_bootstrap = false;

        wp_register_script( 'wptoolset-forms',
            WPTOOLSET_FORMS_RELPATH . '/js/main.js',
            array('jquery', 'underscore'), WPTOOLSET_FORMS_VERSION, false );
        wp_enqueue_script( 'wptoolset-forms' );

        if ( is_admin() ) {
            wp_register_style( 'wptoolset-forms-admin',
                WPTOOLSET_FORMS_RELPATH . '/css/admin.css', array(),
                WPTOOLSET_FORMS_VERSION );
            wp_enqueue_style( 'wptoolset-forms-admin' );
        } else {
            wp_register_style( 'wptoolset-forms-cred',
                WPTOOLSET_FORMS_RELPATH . '/css/cred.css', array(),
                WPTOOLSET_FORMS_VERSION );
            wp_enqueue_style( 'wptoolset-forms-cred' );

            $cred_cred_settings = get_option( 'cred_cred_settings' );
            if ( array_key_exists( 'use_bootstrap', $cred_cred_settings ) && $cred_cred_settings['use_bootstrap'] ) {
                $this->_use_bootstrap = true;
            /*
                wp_register_style(
                    'bootstrap-css',
                    '//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css',
                    array(),
                    '3.1.1'
                );
                wp_register_style(
                    'bootstrap-theme-css',
                    '//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap-theme.min.css',
                    array('bootstrap-css'),
                    '3.1.1'
                );
                wp_enqueue_style('bootstrap-theme-css');
             */
            }
        }
    }

    /**
     * (non-PHPdoc)
     * @see classes/FormAbstract::formNameExists()
     */
    public function formNameExists( &$nameForm ) {
        if ( !in_array( $nameForm, $GLOBALS['formFactories'] ) ) {
            $GLOBALS['formFactories'][] = $nameForm;
            return false;
        } else {
            echo "Form name already exists!";
            return true;
        }
    }

    /**
     * getClassFromType
     * Return the class name from a type
     * @param unknown_type $type
     */
    protected function getClassFromType( $type ) {
        return CLASS_NAME_PREFIX . ucfirst( $type );
    }

    /**
     * (non-PHPdoc)
     * @see classes/FormAbstract::getFieldObject()
     */
    public function getFieldObject( $data, $global_name_field, $value ) {
        if ( $class = $this->loadFieldClass( $data['type'] ) ) {
            return new $class( $data, $global_name_field, $value );
        }
        return null;
    }

    /**
     * (non-PHPdoc)
     * @see classes/FormAbstract::addFormField()
     */
    public function addFormField( $data ) {
        //check mandatory info in data like type and name field
        $global_name_field = $this->nameForm . '_field_' . $this->field_count;
        $obj = $this->getFieldObject( $data, $global_name_field );
        $this->form[$global_name_field] = $obj->metaform();
        $this->field_count++;
    }

    /**
     * (non-PHPdoc)
     * @see classes/FormAbstract::createForm()
     */
    public function createForm( $nameForm = 'default' ) {
        if ( $this->formNameExists( $nameForm ) ) return;
        $this->theForm->autoHandle( $nameForm, $this->form );

        $out = "";
        $out .= '<form method="post" action="" id="' . $nameForm . '">';
        $out .= $this->theForm->renderElements( $this->form );
        //$out .= $this->theForm->renderForm();
        $out .= '</form>';

        return $out;
    }

    /**
     * (non-PHPdoc)
     * @see classes/FormAbstract::displayForm()
     */
    public function displayForm( $nameForm = 'default' ) {
        if ( $this->formNameExists( $nameForm ) ) return;
        $myform = $this->theForm;
        $this->theForm->autoHandle( $nameForm, $this->form );

        echo '<form method="post" action="" id="' . $nameForm . '">';
        echo $this->theForm->renderForm();
        echo '</form>';
    }

    /**
     * metaform
     * @param type $name
     * @param type $type
     * @param type $config
     * @param type $global_name_field
     * @param type $value
     * @return type
     */
    public function metaform( $config, $global_name_field, $value )
    {
        /**
         * add bootstrap config to every field
         */
        $config['use_bootstrap'] = $this->theForm->form_settings['use_bootstrap'];
        $config['has_media_button'] = $this->theForm->form_settings['has_media_button'];
        $htmlArray = array();
        $_gnf = $global_name_field;
        $_cfg = $config;
        if ( empty( $value ) ) $value = array(null);
        elseif ( !is_array( $value ) ) $value = array($value);
        $count = 0;
        foreach ( $value as $val ) {
            if ( !empty( $config['repetitive'] ) ) {
                $_gnf = $_cfg['name'] = "{$global_name_field}[{$count}]";
            }
            
            if ( !is_wp_error( $field = $this->loadField( $_cfg, $_gnf, $val ) ) ) {                
                $form = $field->metaform();                
                // Set $config['validate'] to trigger PHP validation
                // when rendering metaform
                if ( !empty( $_cfg['validate'] ) && is_wp_error( $valid = $this->validateField( $field, $val ) ) ) {
                    $key = key( $form );
                    $error = $valid->get_error_data();
                    if ( is_array( $error ) ) {
                        $error = array_shift( $error );
                    }
                    $form[$key]['#error'] = $error;
                }
                
                if ( isset( $_cfg['validation_error'] ) ) {
                    $key = key( $form );
                    $form[$key]['#error'] = $_cfg['validation_error'];
                }
                $this->form[$global_name_field] = $form;
                $this->field_count++;
                $htmlArray[] = $this->theForm->renderElements( $form );
                if ( empty( $config['repetitive'] ) ) break;
                $count++;
            } else echo "error";
        }
        if ( !empty( $htmlArray ) && isset($config['repetitive']) && $config['repetitive'] ) {
            $_gnf = $_cfg['name'] = "{$global_name_field}[%%{$count}%%]";
            if ( !is_wp_error( $field = $this->loadField( $_cfg, $_gnf, null ) ) ) {
                $tpl = $this->_tplItem( $config,
                        $this->theForm->renderElements( $field->metaform() ) );
                $this->_repetitive()->add( $config, $tpl );
            }
        }
        return !empty( $htmlArray ) ? $this->_tpl( $config, $htmlArray ) : '';
    }

    /**
     * 
     * @staticvar array $loaded
     * @param type $config
     * @param string $global_name_field
     * @param type $value
     * @return \WP_Error|\class
     */
    public function loadField( $config, $global_name_field, $value ){
        global $wp_version;
        static $loaded = array();
        $type = $config['type'];
        $global_name_field = $this->nameForm . '_field_' . $this->field_count;
        $field = $this->getFieldObject( $config, $global_name_field, $value );

        if ( is_null( $field ) ) {
            return new WP_Error( 'wptoolset_forms', 'wrong field type' );
        }

        $settings = $field->getSettings();
        if ( isset( $settings['min_wp_version'] ) && version_compare( $wp_version,
                        $settings['min_wp_version'], '<' ) ) {
            return new WP_Error( 'wptoolset_forms', 'Higher WP version required' );
        }

        $this->_setGlobalField( $field );

        // Load/enqueue scripts
        if ( !isset( $loaded[$type] ) ) {
            $loaded[$type] = 1;
            // These should be performed only once
            $field::registerScripts();
            $field::registerStyles();
            $field->enqueueScripts();
            $field->enqueueStyles();
            $field::addFilters();
            $field::addActions();
        }
        $this->_checkValidation( $config );
        $this->_checkConditional( $config );

        return $field;
    }

    protected function _checkValidation( $config ) {
        if ( isset( $config['validation'] ) && is_null( $this->_validation ) ) {
            require_once 'class.validation.php';
            $this->_validation = new WPToolset_Forms_Validation( $this->nameForm );                
        }
    }

    protected function _checkConditional( $config ) {
        if ( !empty( $config['conditional'] ) ) {
            $this->getConditionalClass()->add( $config );
        }
    }

    public function addConditional( $config ) {
        $this->getConditionalClass()->add( $config );
    }
    
    public function getConditionalClass(){
        if ( is_null( $this->_conditional ) ) {
            require_once 'class.conditional.php';
            $this->_conditional = new WPToolset_Forms_Conditional( $this->nameForm );
        }
        return $this->_conditional;
    }

    protected function _repetitive() {
        if ( is_null( $this->_repetitive ) ) {
            require_once 'class.repetitive.php';
            $this->_repetitive = new WPToolset_Forms_Repetitive();
        }
        return $this->_repetitive;
    }

    protected function _tpl( $cfg, $html ) {
        ob_start();
        include WPTOOLSET_FORMS_ABSPATH . '/templates/metaform.php';
        $o = ob_get_contents();
        ob_get_clean();
        return $o;
    }

    protected function _tplItem( $cfg, $out ) {
        ob_start();
        include WPTOOLSET_FORMS_ABSPATH . '/templates/metaform-item.php';
        $o = ob_get_contents();
        ob_get_clean();
        return $o;
    }    
    
    public function validateField( $field, $value ) {           
        if ( is_array( $field ) ) {
            $field = $this->loadField( $field, $field['name'], $value );
        }        
        if ( !is_wp_error( $field ) ) {
            if ( $field->getValidationData() ) {
                return $this->_validation->validateField( $field );
            }
            return true;
        }
        return new WP_Error( 'wpt-validation', 'Field do not exist',
                array('Field do not exist') );
    }
    
    protected function _setGlobalField( $field ) {
        global $wptoolset_field;
        $wptoolset_field = $field;
    }

    public function __toString() {
        return join( "\n", $this->elements );
    }
    
    public function loadFieldClass( $type ) {
        $type = strtolower( $type );
        $class = $this->getClassFromType( $type );
        if ( !class_exists( $class ) ) {
            $file = WPTOOLSET_FORMS_ABSPATH . "/classes/class.{$type}.php";
            if ( file_exists( $file ) ) {
                require_once $file;
                return $class;
            } else {
                // third party fields array $type => __FILE__
                $third_party_fields = apply_filters( 'wptoolset_registered_fields',
                        array() );
                if ( isset( $third_party_fields[$type] ) && file_exists( $third_party_fields[$type] ) ) {
                    require_once $third_party_fields[$type];
                    return $class;
                }
            }
        }
        return class_exists( $class ) ? $class : false;
    }

}
